//
//  NSDate+RWAWS.h
//  S3Uploader
//
//  Created by Tom Bradley on 16/08/2019.
//  Copyright © 2019 Codebots. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

extern NSString *const AWSDateRFC822DateFormat1;
extern NSString *const AWSDateISO8601DateFormat1;
extern NSString *const AWSDateISO8601DateFormat2;
extern NSString *const AWSDateISO8601DateFormat3;
extern NSString *const AWSDateShortDateFormat1;
extern NSString *const AWSDateShortDateFormat2;

@interface NSDate (RWAWS)

+ (NSDate *)aws_clockSkewFixedDate;
+ (NSDateFormatter *)aws_RFC822Date1Formatter;
+ (NSDateFormatter *)aws_ISO8601Date1Formatter;
+ (NSDateFormatter *)aws_ISO8601Date2Formatter;
+ (NSDateFormatter *)aws_ISO8601Date3Formatter;
+ (NSDateFormatter *)aws_ShortDateFormat1Formatter;
+ (NSDateFormatter *)aws_ShortDateFormat2Formatter;
- (NSString *)aws_stringValue:(NSString *)dateFormat;

@end

NS_ASSUME_NONNULL_END
